/*
    libparted - a library for manipulating disk partitions
    Copyright (C) 1998-2000 Free Software Foundation, Inc.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef PED_DISK_MAC_H_INCLUDED
#define PED_DISK_MAC_H_INCLUDED

#include <parted/device.h>
#include <parted/endian.h>

typedef struct {
	char		volume_name[33];	/* eg: "Games" */
	char		system_name[33];	/* eg: "Apple_Unix_SVR2" */
	char		processor_name[17];

	int		is_boot;
	int		is_driver;
	int		is_root;
	int		is_swap;

	PedSector	data_region_length;
	PedSector	boot_region_length;

	long long	boot_base_address;
	long long	boot_entry_address;
	int		boot_checksum;

	__u32		status;
	__u32		driver_sig;
} MacPartitionData;

typedef struct {
	int		ghost_size;		/* sectors per "driver" block */
	int		part_map_entry_count;	/* # entries (incl. ghost) */
	int		part_map_entry_num;	/* partition map location */

	int		active_part_entry_count;	/* # real partitions */
	int		free_part_entry_count;		/* # free space */
	int		last_part_entry_num;		/* last entry number */
} MacDiskData;

#define MAC_NAME	"mac"

#endif /* PED_DISK_MAC_H_INCLUDED */

