/*
    libparted - a library for manipulating disk partitions
    Copyright (C) 1998-2000 Free Software Foundation, Inc.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef PED_FILESYS_H_INCLUDED
#define PED_FILESYS_H_INCLUDED

typedef struct _PedFileSystem		PedFileSystem;
typedef struct _PedFileSystemType	PedFileSystemType;
typedef const struct _PedFileSystemOps	PedFileSystemOps;

#include <parted/disk.h>
#include <parted/exception.h>
#include <parted/constraint.h>
#include <stdio.h>

struct _PedFileSystemOps {
	int (*probe) (const PedGeometry* geom);
	int (*clobber) (PedGeometry* geom);

	PedFileSystem* (*open) (const PedGeometry* geom);
	PedFileSystem* (*create) (PedGeometry* geom);
	int (*close) (PedFileSystem* fs);
	int (*check) (PedFileSystem* fs);
	int (*copy) (const PedFileSystem* fs, PedGeometry* geom);
	int (*resize) (PedFileSystem* fs, const PedGeometry* geom);

	PedConstraint* (*get_resize_constraint) (const PedFileSystem* fs);
	int (*set_system) (const PedFileSystem* fs, PedPartition* part,
			   const PedDiskType* disk_type);
};

struct _PedFileSystemType {
	PedFileSystemType*		next;
	const char* const		name;
	PedFileSystemOps* const		ops;
};

struct _PedFileSystem {
	PedFileSystemType*		type;
	PedGeometry*			geom;
	void*				type_specific;
};

extern void ped_file_system_type_register (PedFileSystemType* type);
extern void ped_file_system_type_unregister (PedFileSystemType* type);

extern PedFileSystemType* ped_file_system_type_get (const char* name);
extern PedFileSystemType*
ped_file_system_type_get_next (PedFileSystemType* fs_type);

extern PedFileSystemType* ped_file_system_probe (const PedGeometry* geom);
extern int ped_file_system_clobber (PedGeometry* geom);

extern PedFileSystem* ped_file_system_open (PedGeometry* geom);
extern PedFileSystem* ped_file_system_create (PedGeometry* geom,
					      PedFileSystemType* type);
extern int ped_file_system_close (PedFileSystem* fs);
extern int ped_file_system_check (PedFileSystem* fs);
extern int ped_file_system_copy (const PedFileSystem* fs, PedGeometry* geom);
extern int ped_file_system_resize (PedFileSystem* fs, const PedGeometry* geom);
extern PedConstraint* ped_file_system_get_resize_constraint (
				const PedFileSystem* fs);

#endif /* PED_FILESYS_H_INCLUDED */
