/*
    libparted - a library for manipulating disk partitions
    Copyright (C) 1998-2000 Free Software Foundation, Inc.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef PED_DEVICE_H_INCLUDED
#define PED_DEVICE_H_INCLUDED

#define PED_SECTOR_SIZE		512
typedef long long PedSector;

typedef enum {
	PED_DEVICE_UNKNOWN	= 0,
	PED_DEVICE_SCSI		= 1,
	PED_DEVICE_IDE		= 2,
	PED_DEVICE_DAC960	= 3,
	PED_DEVICE_CPQARRAY	= 4,
	PED_DEVICE_FILE		= 5
} PedDeviceType;

typedef struct _PedDevice PedDevice;

/* A hard disk device - eg. /dev/hda, not /dev/hda3 */
struct _PedDevice {
	PedDevice*	next;

	char*		model;			/* description of hardware */
	char*		path;			/* device /dev entry */

	PedDeviceType	type;			/* SCSI, IDE, etc. */
	int		sector_size;
	PedSector	length;

	int		open_count;
	int		read_only;
	int		external_mode;
	int		dirty;
	int		boot_dirty;
	int		fd;

/* x86-specific: TODO hide this in arch_specific.  But argghh!  The disk
 * label stuff needs it, not to mention front-ends :-( */
	int		heads, sectors, cylinders;
	int		geom_known;
	int		geom_already_guessed;
	short		host, did;
};

extern void ped_device_probe_all ();
extern void ped_device_free_all ();

extern PedDevice* ped_device_get (const char* name);
extern PedDevice* ped_device_get_next (const PedDevice* dev);
extern int ped_device_open (PedDevice* dev);
extern int ped_device_close (PedDevice* dev);

extern int ped_device_begin_external_access (PedDevice* dev);
extern int ped_device_end_external_access (PedDevice* dev);

extern int ped_device_read (const PedDevice* dev, void* buffer,
			    PedSector start, PedSector count);
extern int ped_device_write (PedDevice* dev, const void* buffer,
			     PedSector start, PedSector count);
extern int ped_device_sync (PedDevice* dev);
extern PedSector ped_device_check (PedDevice* dev, void* buffer,
				   PedSector start, PedSector count);

#endif /* PED_DEVICE_H_INCLUDED */

