/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
#ifndef _E_CATEGORIES_MASTER_LIST_H_
#define _E_CATEGORIES_MASTER_LIST_H_

#include <gtk/gtkobject.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define E_CATEGORIES_MASTER_LIST_TYPE        (e_categories_master_list_get_type ())
#define E_CATEGORIES_MASTER_LIST(o)          (GTK_CHECK_CAST ((o), E_CATEGORIES_MASTER_LIST_TYPE, ECategoriesMasterList))
#define E_CATEGORIES_MASTER_LIST_CLASS(k)    (GTK_CHECK_CLASS_CAST((k), E_CATEGORIES_MASTER_LIST_TYPE, ECategoriesMasterListClass))
#define E_IS_CATEGORIES_MASTER_LIST(o)       (GTK_CHECK_TYPE ((o), E_CATEGORIES_MASTER_LIST_TYPE))
#define E_IS_CATEGORIES_MASTER_LIST_CLASS(k) (GTK_CHECK_CLASS_TYPE ((k), E_CATEGORIES_MASTER_LIST_TYPE))

typedef struct {
	GtkObject   base;
} ECategoriesMasterList;

typedef struct {
	GtkObjectClass parent_class;

	/*
	 * Virtual methods
	 */
	int    (*count)   (ECategoriesMasterList *etm);
	char  *(*nth)     (ECategoriesMasterList *etm, int n);
	void   (*append)  (ECategoriesMasterList *etm, const char *category);
	void   (*delete)  (ECategoriesMasterList *etm, int n);
	void   (*commit)  (ECategoriesMasterList *etm);

	void   (*reset)   (ECategoriesMasterList *etm);

	/* Signals */
	void   (*changed) (ECategoriesMasterList *etm);
} ECategoriesMasterListClass;

GtkType  e_categories_master_list_get_type  (void);

/**/
int      e_categories_master_list_count     (ECategoriesMasterList *ecml);
char    *e_categories_master_list_nth       (ECategoriesMasterList *ecml,
					     int                    n);
void     e_categories_master_list_append    (ECategoriesMasterList *ecml,
					     const char            *category);
void     e_categories_master_list_delete    (ECategoriesMasterList *ecml,
					     int                    n);
void     e_categories_master_list_commit    (ECategoriesMasterList *ecml);
void     e_categories_master_list_reset     (ECategoriesMasterList *ecml);

/* Routines for emitting signals on the e_table */
void     e_categories_master_list_changed   (ECategoriesMasterList *ecml);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* _E_CATEGORIES_MASTER_LIST_H_ */
