/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *
 * The contents of this file are subject to the Netscape Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/NPL/
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is Netscape
 * Communications Corporation.  Portions created by Netscape are
 * Copyright (C) 1998 Netscape Communications Corporation. All
 * Rights Reserved.
 *
 * Contributor(s): 
 */


#include "nsObject.h"


CList nsObject::s_liveChain;
PRMonitor *nsObject::s_liveChainMutex = PR_NewMonitor();

#ifdef _DEBUG
int32 nsObject::s_nObjects = 0;
#endif

/**
 * constructor
 */
nsObject::nsObject()
{
    //
    // Add the new object the chain of allocated nsObjects
    //
    PR_EnterMonitor(s_liveChainMutex);
    s_liveChain.Append(m_link);
    PR_ExitMonitor(s_liveChainMutex);
#ifdef _DEBUG
    s_nObjects++;
#endif
}


/**
 * destructor
 */
nsObject::~nsObject()
{
#ifdef _DEBUG
    s_nObjects--;
#endif
    //
    // Remove from the chain of allocated nsObjects
    //
    PR_EnterMonitor(s_liveChainMutex);
    m_link.Remove();
    PR_ExitMonitor(s_liveChainMutex);
}


/**
 * static utility. Delete all live objects
 */

void nsObject::DeleteAllObjects(void)
{
    PR_EnterMonitor(s_liveChainMutex);

    while (!s_liveChain.IsEmpty()) {
        nsObject *pnsObject;

        pnsObject = (nsObject*)OBJECT_PTR_FROM_CLIST(nsObject, s_liveChain.next);

        // Remove the event from the chain...
        pnsObject->m_link.Remove();
        delete pnsObject;
    }

    PR_ExitMonitor(s_liveChainMutex);
}

