/* Implement Input/Output runtime actions for CHILL.
   Copyright (C) 1992,1993 Free Software Foundation, Inc.
   Author: Wilfried Moser, et al

This file is part of GNU CC.

GNU CC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU CC; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "fileio.h"

void
__settextaccess( Text_Mode*   the_text,
                 Access_Mode* the_access,
                 char*        file,
                 int          line )
{
  if( !the_text )
    CHILLEXCEPTION( file, line, EMPTY, NULL_TEXT );

  if( !the_access )
    CHILLEXCEPTION( file, line, EMPTY, NULL_ACCESS );  

  CLR_FLAG( the_text->access_sub, IO_TEXTIO );

  the_text->access_sub = the_access;
  SET_FLAG( the_access, IO_TEXTIO );
}
