/*
 * Decompiled with CFR 0.152.
 */
package accessories.plugins;

import freemind.extensions.PermanentNodeHookAdapter;
import freemind.modes.MindMapNode;
import java.text.MessageFormat;
import java.util.ListIterator;

public class CreationModificationPlugin
extends PermanentNodeHookAdapter {
    private static final String CREATED = "CREATED";
    private static final String MODIFIED = "MODIFIED";
    private long created;
    private long modified;
    private String tooltipFormat;

    private void setStyle(MindMapNode node) {
        Object[] messageArguments = new Object[]{node.getHistoryInformation().getCreatedAt(), node.getHistoryInformation().getLastModifiedAt()};
        if (this.tooltipFormat == null) {
            this.tooltipFormat = this.getResourceString("tooltip_format");
        }
        MessageFormat formatter = new MessageFormat(this.tooltipFormat);
        String message = formatter.format(messageArguments);
        this.setToolTip(node, this.getName(), message);
        this.logger.finest(this + "Tooltiop for " + node + " with parent " + node.getParentNode() + " is " + message);
    }

    private static long toLong(String createdString) {
        try {
            return Long.valueOf(createdString);
        }
        catch (Exception e) {
            return System.currentTimeMillis();
        }
    }

    public void shutdownMapHook() {
        this.removeToolTipRecursively(this.getNode());
        super.shutdownMapHook();
    }

    private void removeToolTipRecursively(MindMapNode node) {
        this.setToolTip(node, this.getName(), null);
        ListIterator i = node.childrenUnfolded();
        while (i.hasNext()) {
            MindMapNode child = (MindMapNode)i.next();
            this.removeToolTipRecursively(child);
        }
    }

    private long getCreated() {
        return this.getNode().getHistoryInformation().getCreatedAt().getTime();
    }

    private long getModified() {
        return this.getNode().getHistoryInformation().getLastModifiedAt().getTime();
    }

    public void onUpdateChildrenHook(MindMapNode updatedNode) {
        super.onUpdateChildrenHook(updatedNode);
        this.setStyleRecursive(updatedNode);
    }

    public void onUpdateNodeHook() {
        super.onUpdateNodeHook();
        this.setStyle(this.getNode());
    }

    public void invoke(MindMapNode node) {
        super.invoke(node);
        this.setStyleRecursive(node);
    }

    private void setStyleRecursive(MindMapNode node) {
        this.logger.finest("setStyle " + node);
        this.setStyle(node);
        ListIterator i = node.childrenFolded();
        while (i.hasNext()) {
            MindMapNode child = (MindMapNode)i.next();
            this.setStyleRecursive(child);
        }
    }
}

