/*
 * Decompiled with CFR 0.152.
 */
package accessories.plugins;

import freemind.extensions.ExportHook;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;

public class ExportToImage
extends ExportHook {
    public void startupMapHook() {
        super.startupMapHook();
        BufferedImage image = this.createBufferedImage();
        if (image != null) {
            String imageType = this.getResourceString("image_type");
            if (!imageType.equals("clipboard")) {
                this.exportToImage(image, imageType, this.getResourceString("image_description"));
            } else {
                this.setClipboard(image);
            }
        }
    }

    public boolean exportToImage(BufferedImage image, String type, String description) {
        File chosenFile = this.chooseFile(type, description);
        if (chosenFile == null) {
            return false;
        }
        try {
            this.getController().getFrame().setWaitingCursor(true);
            FileOutputStream out = new FileOutputStream(chosenFile);
            ImageIO.write((RenderedImage)image, type, out);
            out.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        this.getController().getFrame().setWaitingCursor(false);
        return true;
    }

    public void setClipboard(BufferedImage image) {
        ImageSelection imgSel = new ImageSelection(image);
        this.getController().getClipboard().setContents(imgSel, null);
    }

    public static class ImageSelection
    implements Transferable {
        private BufferedImage image;
        private DataFlavor imageFlavor;

        public ImageSelection(BufferedImage image) {
            this.image = image;
            try {
                this.imageFlavor = new DataFlavor("image/jpeg");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{this.imageFlavor};
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return this.imageFlavor.equals(flavor);
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!this.imageFlavor.equals(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)this.image, "JPEG", out);
            return out;
        }
    }
}

