/*
 * Decompiled with CFR 0.152.
 */
package freemind.controller;

import freemind.controller.Controller;
import freemind.main.Tools;
import freemind.view.mindmapview.NodeView;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;

public class NodeMouseMotionListener
implements MouseMotionListener,
MouseListener {
    private final Controller c;
    private static Logger logger;
    private static Tools.IntHolder timeForDelayedSelection;
    private static Tools.BooleanHolder delayedSelectionEnabled;
    private Timer timerForDelayedSelection;
    private Rectangle controlRegionForDelayedSelection;

    public static void updateSelectionMethod(Controller c) {
        if (timeForDelayedSelection == null) {
            timeForDelayedSelection = new Tools.IntHolder();
        }
        delayedSelectionEnabled = new Tools.BooleanHolder();
        delayedSelectionEnabled.setValue(!c.getFrame().getProperty("selection_method").equals("selection_method_direct"));
        if (c.getFrame().getProperty("selection_method").equals("selection_method_by_click")) {
            timeForDelayedSelection.setValue(Integer.MAX_VALUE);
        } else {
            timeForDelayedSelection.setValue(Integer.parseInt(c.getFrame().getProperty("time_for_delayed_selection")));
        }
    }

    public NodeMouseMotionListener(Controller controller) {
        this.c = controller;
        if (logger == null) {
            logger = this.c.getFrame().getLogger(this.getClass().getName());
        }
        if (delayedSelectionEnabled == null) {
            NodeMouseMotionListener.updateSelectionMethod(this.c);
        }
    }

    public void mouseMoved(MouseEvent e) {
        logger.finest("Event: mouseMoved");
        NodeView node = (NodeView)e.getComponent();
        boolean isLink = node.updateCursor(e.getX());
        if (isLink) {
            this.c.getFrame().out(this.c.getModeController().getLinkShortText(node.getModel()));
        }
        if (this.controlRegionForDelayedSelection != null && delayedSelectionEnabled.getValue() && !this.controlRegionForDelayedSelection.contains(e.getPoint())) {
            this.createTimer(e);
        }
    }

    public void mouseDragged(MouseEvent e) {
        logger.fine("Event: mouseDragged");
        this.stopTimerForDelayedSelection();
        NodeView nodeV = (NodeView)e.getSource();
        if (!this.c.getView().isSelected(nodeV)) {
            this.c.getMode().getModeController().extendSelection(e);
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        logger.finest("Event: mouseEntered");
        this.createTimer(e);
    }

    public void mousePressed(MouseEvent e) {
        logger.fine("Event: mousePressed");
        this.c.getMode().getModeController().showPopupMenu(e);
    }

    public void mouseExited(MouseEvent e) {
        logger.finest("Event: mouseExited");
        this.stopTimerForDelayedSelection();
    }

    public void mouseReleased(MouseEvent e) {
        logger.fine("Event: mouseReleased");
        this.stopTimerForDelayedSelection();
        this.c.getMode().getModeController().extendSelection(e);
        this.c.getMode().getModeController().showPopupMenu(e);
        if (e.isConsumed()) {
            return;
        }
        if (e.getModifiers() == 16) {
            if (e.getClickCount() % 2 == 0) {
                this.c.getMode().getModeController().doubleClick(e);
            } else {
                this.c.getMode().getModeController().plainClick(e);
            }
            e.consume();
        }
    }

    protected Rectangle getControlRegion(Point2D p) {
        int side = 8;
        return new Rectangle((int)(p.getX() - (double)(side / 2)), (int)(p.getY() - (double)(side / 2)), side, side);
    }

    public void createTimer(MouseEvent e) {
        this.stopTimerForDelayedSelection();
        this.controlRegionForDelayedSelection = this.getControlRegion(e.getPoint());
        this.timerForDelayedSelection = new Timer();
        this.timerForDelayedSelection.schedule((TimerTask)new timeDelayedSelection(this.c, e), delayedSelectionEnabled.getValue() ? (long)timeForDelayedSelection.getValue() : 0L);
    }

    protected void stopTimerForDelayedSelection() {
        if (this.timerForDelayedSelection != null) {
            this.timerForDelayedSelection.cancel();
        }
        this.timerForDelayedSelection = null;
        this.controlRegionForDelayedSelection = null;
    }

    protected class timeDelayedSelection
    extends TimerTask {
        private final Controller c;
        private final MouseEvent e;

        timeDelayedSelection(Controller c, MouseEvent e) {
            this.c = c;
            this.e = e;
        }

        public void run() {
            if (this.e.getModifiers() == 0 && !this.c.getMode().getModeController().isBlocked() && this.c.getView().getSelecteds().size() <= 1) {
                this.c.getMode().getModeController().extendSelection(this.e);
            }
        }
    }
}

