/*
 * Decompiled with CFR 0.152.
 */
package freemind.extensions;

import freemind.extensions.HookFactory;
import java.io.File;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ImportWizard {
    public final String lookFor = ".xml";
    public Vector CLASS_LIST = new Vector(500);

    public void buildClassList() {
        String classPath = System.getProperty("java.class.path");
        String classPathSeparator = File.pathSeparator;
        classPath = HookFactory.getFreemindBaseDir() + classPathSeparator + classPath;
        StringTokenizer st = new StringTokenizer(classPath, classPathSeparator);
        while (st.hasMoreTokens()) {
            String classPathEntry = st.nextToken();
            File classPathFile = new File(classPathEntry);
            if (!classPathFile.exists()) continue;
            if (classPathEntry.toLowerCase().endsWith(".jar")) {
                this.addClassesFromZip(this.CLASS_LIST, classPathFile);
                continue;
            }
            if (classPathEntry.toLowerCase().endsWith(".zip")) {
                this.addClassesFromZip(this.CLASS_LIST, classPathFile);
                continue;
            }
            if (!classPathFile.isDirectory()) continue;
            this.addClassesFromDir(this.CLASS_LIST, classPathFile, classPathFile);
        }
    }

    public void addClassesFromZip(Vector classList, File classPathFile) {
        try {
            ZipFile zipFile = new ZipFile(classPathFile);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String current = zipEntry.getName();
                if (!current.toLowerCase().endsWith(".xml")) continue;
                current = current.substring(0, current.length() - ".xml".length());
                current = current.replace('/', '.');
                current = current.replace('\\', '.');
                classList.addElement(current);
            }
        }
        catch (Exception ex) {
            System.err.println("Problem opening " + classPathFile + " with zip.");
        }
    }

    public void addClassesFromDir(Vector classList, File rootDir, File currentDir) {
        String[] files = currentDir.list();
        for (int i = 0; i < files.length; ++i) {
            String current = files[i];
            if (current.toLowerCase().endsWith(".xml")) {
                String rootPath = rootDir.getPath();
                String currentPath = currentDir.getPath();
                if (!currentPath.startsWith(rootPath)) {
                    System.err.println("currentPath doesn't start with rootPath!\nrootPath: " + rootPath + "\n" + "currentPath: " + currentPath + "\n");
                    continue;
                }
                current = current.substring(0, current.length() - ".xml".length());
                String packageName = currentPath.substring(rootPath.length());
                if (packageName.length() > 0) {
                    packageName = packageName.replace('\\', '.');
                    packageName = packageName.replace('/', '.');
                    classList.addElement(packageName.substring(1) + '.' + current);
                    continue;
                }
                classList.addElement(current);
                continue;
            }
            File currentFile = new File(currentDir, current);
            if (!currentFile.isDirectory()) continue;
            this.addClassesFromDir(classList, rootDir, currentFile);
        }
    }
}

