/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.actions;

import freemind.controller.Controller;
import freemind.controller.actions.ActionPair;
import freemind.controller.actions.ActorXml;
import freemind.controller.actions.FreemindAction;
import freemind.controller.actions.generated.instance.ArrowLinkColorXmlAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.main.Tools;
import freemind.modes.LineAdapter;
import freemind.modes.MindMapLink;
import freemind.modes.MindMapLinkRegistry;
import freemind.modes.ModeController;
import freemind.modes.mindmapmode.MindMapArrowLinkModel;
import java.awt.Color;
import java.awt.event.ActionEvent;
import javax.xml.bind.JAXBException;

public class ColorArrowLinkAction
extends FreemindAction
implements ActorXml {
    MindMapArrowLinkModel arrowLink;
    private final ModeController controller;
    static /* synthetic */ Class class$freemind$controller$actions$generated$instance$ArrowLinkColorXmlAction;

    public ColorArrowLinkAction(ModeController controller, MindMapArrowLinkModel arrowLink) {
        super("arrow_link_color", "images/Colors24.gif", controller);
        this.controller = controller;
        this.arrowLink = arrowLink;
        this.addActor(this);
    }

    public void actionPerformed(ActionEvent e) {
        Color selectedColor = this.arrowLink.getColor();
        Color color = Controller.showCommonJColorChooserDialog(this.controller.getView().getSelected(), (String)this.getValue("Name"), selectedColor);
        if (color == null) {
            return;
        }
        this.setArrowLinkColor(this.arrowLink, color);
    }

    public void setArrowLinkColor(MindMapLink arrowLink, Color color) {
        this.controller.getActionFactory().startTransaction((String)this.getValue("Name"));
        this.controller.getActionFactory().executeAction(this.getActionPair(arrowLink, color));
        this.controller.getActionFactory().endTransaction((String)this.getValue("Name"));
    }

    private ActionPair getActionPair(MindMapLink arrowLink, Color color) {
        return new ActionPair(this.createArrowLinkColorXmlAction(arrowLink, color), this.createArrowLinkColorXmlAction(arrowLink, arrowLink.getColor()));
    }

    public void act(XmlAction action) {
        if (action instanceof ArrowLinkColorXmlAction) {
            ArrowLinkColorXmlAction colorAction = (ArrowLinkColorXmlAction)action;
            MindMapLink link = this.getLinkRegistry().getLinkForID(colorAction.getId());
            ((LineAdapter)((Object)link)).setColor(Tools.xmlToColor(colorAction.getColor()));
            this.controller.nodeChanged(link.getSource());
        }
    }

    public Class getDoActionClass() {
        return class$freemind$controller$actions$generated$instance$ArrowLinkColorXmlAction == null ? (class$freemind$controller$actions$generated$instance$ArrowLinkColorXmlAction = ColorArrowLinkAction.class$("freemind.controller.actions.generated.instance.ArrowLinkColorXmlAction")) : class$freemind$controller$actions$generated$instance$ArrowLinkColorXmlAction;
    }

    private ArrowLinkColorXmlAction createArrowLinkColorXmlAction(MindMapLink arrowLink, Color color) {
        try {
            ArrowLinkColorXmlAction action = this.controller.getActionXmlFactory().createArrowLinkColorXmlAction();
            action.setColor(Tools.colorToXml(color));
            action.setId(arrowLink.getUniqueID());
            return action;
        }
        catch (JAXBException e) {
            e.printStackTrace();
            return null;
        }
    }

    private MindMapLinkRegistry getLinkRegistry() {
        return this.controller.getMap().getLinkRegistry();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

