/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.actions;

import freemind.controller.actions.ActionPair;
import freemind.controller.actions.ActorXml;
import freemind.controller.actions.FreemindAction;
import freemind.controller.actions.generated.instance.RevertXmlAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.modes.MindMap;
import freemind.modes.ModeController;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import javax.xml.bind.JAXBException;

public class RevertAction
extends FreemindAction
implements ActorXml {
    private final ModeController controller;
    static /* synthetic */ Class class$freemind$controller$actions$generated$instance$RevertXmlAction;

    public RevertAction(ModeController modeController) {
        super("RevertAction", (String)null, modeController);
        this.controller = modeController;
        this.addActor(this);
    }

    public void actionPerformed(ActionEvent arg0) {
        try {
            File file = this.controller.getMap().getFile();
            RevertXmlAction doAction = this.createRevertXmlAction(file);
            RevertXmlAction undoAction = this.createRevertXmlAction(this.controller.getMap(), null, file.getName());
            this.controller.getActionFactory().startTransaction(this.getClass().getName());
            this.controller.getActionFactory().executeAction(new ActionPair(doAction, undoAction));
            this.controller.getActionFactory().endTransaction(this.getClass().getName());
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void openXmlInsteadOfMap(String xmlFileContent) {
        try {
            RevertXmlAction doAction = this.createRevertXmlAction(xmlFileContent, null, null);
            RevertXmlAction undoAction = this.createRevertXmlAction(this.controller.getMap(), null, null);
            this.controller.getActionFactory().startTransaction(this.getClass().getName());
            this.controller.getActionFactory().executeAction(new ActionPair(doAction, undoAction));
            this.controller.getActionFactory().endTransaction(this.getClass().getName());
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public RevertXmlAction createRevertXmlAction(File file) throws JAXBException, IOException {
        int c;
        String fileName = file.getAbsolutePath();
        FileReader f = new FileReader(file);
        StringBuffer buffer = new StringBuffer();
        while ((c = f.read()) != -1) {
            buffer.append((char)c);
        }
        f.close();
        return this.createRevertXmlAction(buffer.toString(), fileName, null);
    }

    public RevertXmlAction createRevertXmlAction(MindMap map, String fileName, String filePrefix) throws JAXBException, IOException {
        StringWriter writer = new StringWriter();
        map.getXml(writer);
        return this.createRevertXmlAction(writer.getBuffer().toString(), fileName, filePrefix);
    }

    public RevertXmlAction createRevertXmlAction(String xmlPackedFile, String fileName, String filePrefix) throws JAXBException {
        RevertXmlAction revertXmlAction = this.controller.getActionXmlFactory().createRevertXmlAction();
        revertXmlAction.setLocalFileName(fileName);
        revertXmlAction.setMap(xmlPackedFile);
        revertXmlAction.setFilePrefix(filePrefix);
        return revertXmlAction;
    }

    public void act(XmlAction action) {
        if (action instanceof RevertXmlAction) {
            try {
                RevertXmlAction revertAction = (RevertXmlAction)action;
                this.controller.getController().close(true);
                if (revertAction.getLocalFileName() != null) {
                    this.controller.load(new File(revertAction.getLocalFileName()));
                } else {
                    String filePrefix = this.controller.getText("freemind_reverted");
                    if (revertAction.getFilePrefix() != null) {
                        filePrefix = revertAction.getFilePrefix();
                    }
                    File tempFile = File.createTempFile(filePrefix, ".mm", new File(this.controller.getFrame().getFreemindDirectory()));
                    FileWriter fw = new FileWriter(tempFile);
                    fw.write(revertAction.getMap());
                    fw.close();
                    this.controller.load(tempFile);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Class getDoActionClass() {
        return class$freemind$controller$actions$generated$instance$RevertXmlAction == null ? (class$freemind$controller$actions$generated$instance$RevertXmlAction = RevertAction.class$("freemind.controller.actions.generated.instance.RevertXmlAction")) : class$freemind$controller$actions$generated$instance$RevertXmlAction;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

