/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.browsemode;

import freemind.controller.Controller;
import freemind.main.FreeMindApplet;
import freemind.modes.Mode;
import freemind.modes.ModeController;
import freemind.modes.browsemode.BrowseController;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JToolBar;

public class BrowseMode
implements Mode {
    private Controller c;
    private BrowseController modecontroller;
    private final String MODENAME = "Browse";

    public void init(Controller c) {
        this.c = c;
        this.modecontroller = new BrowseController(this);
    }

    public String toString() {
        return "Browse";
    }

    public void activate() {
        String map = this.getController().getFrame().getProperty("browsemode_initial_map");
        if (map != null && map.startsWith(".")) {
            try {
                if (this.getController().getFrame() instanceof FreeMindApplet) {
                    FreeMindApplet applet = (FreeMindApplet)this.getController().getFrame();
                    URL documentBaseUrl = new URL(applet.getDocumentBase(), map);
                    map = documentBaseUrl.toString();
                } else {
                    map = "file:" + System.getProperty("user.dir") + map.substring(1);
                }
            }
            catch (MalformedURLException e) {
                this.getController().errorMessage("Could not open relative URL " + map + ". It is malformed.");
                System.err.println(e);
                return;
            }
        }
        if (map != "") {
            ((BrowseController)this.getModeController()).loadURL(map);
        }
    }

    public void restore(String restoreable) {
    }

    public Controller getController() {
        return this.c;
    }

    public ModeController getModeController() {
        return this.modecontroller;
    }

    public BrowseController getBrowseController() {
        return (BrowseController)this.getModeController();
    }

    public JToolBar getModeToolBar() {
        return ((BrowseController)this.getModeController()).getToolBar();
    }

    public JToolBar getLeftToolBar() {
        return null;
    }
}

