/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode;

import freemind.common.JaxbTools;
import freemind.controller.StructuredMenuHolder;
import freemind.controller.actions.generated.instance.MenuActionBase;
import freemind.controller.actions.generated.instance.MenuCategoryBase;
import freemind.controller.actions.generated.instance.MenuCheckedAction;
import freemind.controller.actions.generated.instance.MenuSeparator;
import freemind.controller.actions.generated.instance.MenuStructure;
import freemind.controller.actions.generated.instance.MenuSubmenu;
import freemind.extensions.HookFactory;
import freemind.extensions.HookRegistration;
import freemind.main.Tools;
import freemind.modes.ControllerAdapter;
import freemind.modes.MapAdapter;
import freemind.modes.MindIcon;
import freemind.modes.MindMapNode;
import freemind.modes.Mode;
import freemind.modes.ModeController;
import freemind.modes.NodeAdapter;
import freemind.modes.actions.ChangeArrowsInArrowLinkAction;
import freemind.modes.actions.ColorArrowLinkAction;
import freemind.modes.actions.GotoLinkNodeAction;
import freemind.modes.actions.IconAction;
import freemind.modes.actions.NewMapAction;
import freemind.modes.actions.NewPreviousSiblingAction;
import freemind.modes.actions.NewSiblingAction;
import freemind.modes.actions.NodeGeneralAction;
import freemind.modes.actions.NodeHookAction;
import freemind.modes.actions.RemoveArrowLinkAction;
import freemind.modes.actions.SingleNodeOperation;
import freemind.modes.mindmapmode.MindMapArrowLinkModel;
import freemind.modes.mindmapmode.MindMapMapModel;
import freemind.modes.mindmapmode.MindMapNodeModel;
import freemind.modes.mindmapmode.MindMapPopupMenu;
import freemind.modes.mindmapmode.MindMapToolBar;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class MindMapController
extends ControllerAdapter {
    private static Logger logger;
    private Vector hookActions;
    private HashMap actionToMenuPositions;
    private MindMapPopupMenu popupmenu;
    private MindMapToolBar toolbar;
    private boolean addAsChildMode = false;
    public Action newMap = new NewMapAction(this, this);
    public Action open = new ControllerAdapter.OpenAction(this);
    public Action save = new ControllerAdapter.SaveAction(this);
    public Action saveAs = new ControllerAdapter.SaveAsAction(this);
    public Action exportToHTML = new ExportToHTMLAction(this);
    public Action exportBranchToHTML = new ExportBranchToHTMLAction(this);
    public Action editLong = new ControllerAdapter.EditLongAction();
    public Action newSibling = new NewSiblingAction(this);
    public Action newPreviousSibling = new NewPreviousSiblingAction(this);
    public Action setLinkByFileChooser = new ControllerAdapter.SetLinkByFileChooserAction();
    public Action setImageByFileChooser = new ControllerAdapter.SetImageByFileChooserAction();
    public Action followLink = new FollowLinkAction();
    public Action exportBranch = new ExportBranchAction();
    public Action importBranch = new ImportBranchAction();
    public Action importLinkedBranch = new ImportLinkedBranchAction();
    public Action importLinkedBranchWithoutRoot = new ImportLinkedBranchWithoutRootAction();
    public Action increaseNodeFont = new NodeGeneralAction((ModeController)this, "increase_node_font_size", null, new SingleNodeOperation(){

        public void apply(MindMapMapModel map, MindMapNodeModel node) {
            MindMapController.this.increaseFontSize(node, 1);
        }
    });
    public Action decreaseNodeFont = new NodeGeneralAction((ModeController)this, "decrease_node_font_size", null, new SingleNodeOperation(){

        public void apply(MindMapMapModel map, MindMapNodeModel node) {
            MindMapController.this.increaseFontSize(node, -1);
        }
    });
    public Vector iconActions = new Vector();
    FileFilter filefilter = new MindMapFilter();
    private MenuStructure mMenuStructure;
    private List pRegistrations;
    private NewNodeCreator myNewNodeCreator = null;
    static /* synthetic */ Class class$freemind$modes$ModeController;
    static /* synthetic */ Class class$freemind$modes$MindMap;

    public MindMapController(Mode mode) {
        super(mode);
        if (logger == null) {
            logger = this.getFrame().getLogger(this.getClass().getName());
        }
        logger.info("createIconActions");
        this.createIconActions();
        logger.info("createNodeHookActions");
        this.createNodeHookActions();
        logger.info("mindmap_menus");
        try {
            InputStream in = this.getFrame().getResource("mindmap_menus.xml").openStream();
            this.mMenuStructure = this.updateMenusFromXml(in);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        logger.info("MindMapPopupMenu");
        this.popupmenu = new MindMapPopupMenu(this);
        logger.info("MindMapToolBar");
        this.toolbar = new MindMapToolBar(this);
        logger.info("setAllActions");
        this.setAllActions(false);
        this.addAsChildMode = Tools.safeEquals(this.getFrame().getProperty("add_as_child"), "true");
        this.pRegistrations = new Vector();
    }

    public void startupController() {
        super.startupController();
        HookFactory hookFactory = this.getFrame().getHookFactory();
        List pluginRegistratios = hookFactory.getRegistrations(this.getClass());
        logger.info("mScheduledActions are executed: " + pluginRegistratios.size());
        Iterator i = pluginRegistratios.iterator();
        while (i.hasNext()) {
            try {
                HookFactory.RegistrationContainer container = (HookFactory.RegistrationContainer)i.next();
                Class registrationClass = container.hookRegistrationClass;
                Constructor hookConstructor = registrationClass.getConstructor(class$freemind$modes$ModeController == null ? MindMapController.class$("freemind.modes.ModeController") : class$freemind$modes$ModeController, class$freemind$modes$MindMap == null ? MindMapController.class$("freemind.modes.MindMap") : class$freemind$modes$MindMap);
                HookRegistration registrationInstance = (HookRegistration)hookConstructor.newInstance(this, this.getMap());
                hookFactory.registerRegistrationContainer(container, registrationInstance);
                registrationInstance.register();
                this.pRegistrations.add(registrationInstance);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void shutdownController() {
        super.shutdownController();
        Iterator i = this.pRegistrations.iterator();
        while (i.hasNext()) {
            HookRegistration registrationInstance = (HookRegistration)i.next();
            registrationInstance.deRegister();
        }
    }

    public MapAdapter newModel() {
        return new MindMapMapModel(this.getFrame());
    }

    private void createIconActions() {
        Vector iconNames = MindIcon.getAllIconNames();
        for (int i = 0; i < iconNames.size(); ++i) {
            String iconName = (String)iconNames.get(i);
            MindIcon myIcon = MindIcon.factory(iconName);
            IconAction myAction = new IconAction(this, myIcon, this.removeLastIconAction);
            this.iconActions.add(myAction);
        }
    }

    private void createNodeHookActions() {
        this.actionToMenuPositions = new HashMap();
        if (this.hookActions == null) {
            this.hookActions = new Vector();
            HookFactory factory = this.getFrame().getHookFactory();
            Vector list = factory.getPossibleNodeHooks(this.getClass());
            Iterator i = list.iterator();
            while (i.hasNext()) {
                String desc = (String)i.next();
                NodeHookAction action = new NodeHookAction(desc, this);
                factory.decorateAction(desc, action);
                this.actionToMenuPositions.put(action, factory.getHookMenuPositions(desc));
                this.hookActions.add(action);
            }
            Vector hooks = factory.getPossibleModeControllerHooks(this.getClass());
            Iterator i2 = hooks.iterator();
            while (i2.hasNext()) {
                String desc = (String)i2.next();
                ControllerAdapter.ModeControllerHookAction action = new ControllerAdapter.ModeControllerHookAction(desc, this);
                factory.decorateAction(desc, action);
                this.actionToMenuPositions.put(action, factory.getHookMenuPositions(desc));
                this.hookActions.add(action);
            }
        }
    }

    public FileFilter getFileFilter() {
        return this.filefilter;
    }

    public void nodeChanged(MindMapNode n) {
        super.nodeChanged(n);
        if (n == this.getSelected()) {
            this.toolbar.selectFontSize(n.getFontSize());
            this.toolbar.selectFontName(n.getFontFamilyName());
        }
    }

    public void anotherNodeSelected(MindMapNode n) {
        super.anotherNodeSelected(n);
        this.toolbar.selectFontSize(((NodeAdapter)n).getFontSize());
        this.toolbar.selectFontName(((NodeAdapter)n).getFontFamilyName());
    }

    public void setNewNodeCreator(NewNodeCreator creator) {
        this.myNewNodeCreator = creator;
    }

    public MindMapNode newNode(Object userObject) {
        if (this.myNewNodeCreator == null) {
            this.myNewNodeCreator = new DefaultMindMapNodeCreator();
        }
        return this.myNewNodeCreator.createNode(userObject);
    }

    public void updateMenus(StructuredMenuHolder holder) {
        this.processMenuCategory(holder, this.mMenuStructure.getMenuCategory(), "");
        for (int i = 0; i < this.hookActions.size(); ++i) {
            Action hookAction = (Action)this.hookActions.get(i);
            List positions = (List)this.actionToMenuPositions.get(hookAction);
            Iterator j = positions.iterator();
            while (j.hasNext()) {
                String pos = (String)j.next();
                holder.addAction(hookAction, pos);
            }
        }
        this.popupmenu.update(holder);
        this.toolbar.update(holder);
        String formatMenuString = "menu_bar/format/";
        this.createPatternSubMenu(holder, formatMenuString);
        this.addIconsToMenu(holder, "menu_bar/insert/icons");
    }

    public void addIconsToMenu(StructuredMenuHolder holder, String iconMenuString) {
        JMenu iconMenu = holder.addMenu(new JMenu(this.getText("icon_menu")), iconMenuString + "/.");
        holder.addAction(this.removeLastIconAction, iconMenuString + "/removeLastIcon");
        holder.addAction(this.removeAllIconsAction, iconMenuString + "/removeAllIcons");
        holder.addSeparator(iconMenuString);
        for (int i = 0; i < this.iconActions.size(); ++i) {
            JMenuItem item = holder.addAction((Action)this.iconActions.get(i), iconMenuString + "/" + i);
        }
    }

    public JMenu createPatternSubMenu(StructuredMenuHolder holder, String formatMenuString) {
        JMenu extensionMenu = holder.addMenu(new JMenu(this.getText("extension_menu")), formatMenuString + "patterns/.");
        for (int i = 0; i < this.patterns.length; ++i) {
            JMenuItem item = holder.addAction(this.patterns[i], formatMenuString + "patterns/" + i);
            item.setAccelerator(KeyStroke.getKeyStroke(this.getFrame().getProperty("keystroke_apply_pattern_" + (i + 1))));
        }
        return extensionMenu;
    }

    public MenuStructure updateMenusFromXml(InputStream in) {
        try {
            Unmarshaller unmarshaller = JaxbTools.getInstance().createUnmarshaller();
            unmarshaller.setValidating(true);
            MenuStructure menus = (MenuStructure)unmarshaller.unmarshal(in);
            return menus;
        }
        catch (JAXBException e) {
            logger.severe(e.getCause() + e.getLocalizedMessage() + e.getMessage());
            e.printStackTrace();
            throw new IllegalArgumentException("Menu structure could not be read.");
        }
    }

    public void processMenuCategory(StructuredMenuHolder holder, List list, String category) {
        String categoryCopy = category;
        Iterator i = list.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (obj instanceof MenuCategoryBase) {
                MenuCategoryBase cat = (MenuCategoryBase)obj;
                String newCategory = categoryCopy + "/" + cat.getName();
                holder.addCategory(newCategory);
                if (cat instanceof MenuSubmenu) {
                    MenuSubmenu submenu = (MenuSubmenu)cat;
                    holder.addMenu(new JMenu(this.getText(submenu.getNameRef())), newCategory + "/.");
                }
                this.processMenuCategory(holder, cat.getMenuCategoryOrMenuSubmenuOrMenuAction(), newCategory);
                continue;
            }
            if (obj instanceof MenuActionBase) {
                MenuActionBase action = (MenuActionBase)obj;
                String field = action.getField();
                String name = action.getName();
                if (name == null) {
                    name = field;
                }
                String keystroke = action.getKeyRef();
                try {
                    Action theAction = (Action)this.getClass().getField(field).get(this);
                    String theCategory = categoryCopy + "/" + name;
                    if (obj instanceof MenuCheckedAction) {
                        this.addCheckBox(holder, theCategory, theAction, keystroke);
                        continue;
                    }
                    this.add(holder, theCategory, theAction, keystroke);
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                continue;
            }
            if (!(obj instanceof MenuSeparator)) continue;
            holder.addSeparator(categoryCopy);
        }
    }

    public JPopupMenu getPopupMenu() {
        return this.popupmenu;
    }

    public JPopupMenu getPopupForModel(Object obj) {
        if (obj instanceof MindMapArrowLinkModel) {
            MindMapArrowLinkModel link = (MindMapArrowLinkModel)obj;
            JPopupMenu arrowLinkPopup = new JPopupMenu();
            arrowLinkPopup.addPopupMenuListener(this.popupListenerSingleton);
            this.removeArrowLinkAction.setArrowLink(link);
            arrowLinkPopup.add(new RemoveArrowLinkAction(this, link));
            arrowLinkPopup.add(new ColorArrowLinkAction(this, link));
            arrowLinkPopup.addSeparator();
            JRadioButtonMenuItem itemnn = new JRadioButtonMenuItem(new ChangeArrowsInArrowLinkAction(this, "none", "images/arrow-mode-none.gif", link, false, false));
            JRadioButtonMenuItem itemnt = new JRadioButtonMenuItem(new ChangeArrowsInArrowLinkAction(this, "forward", "images/arrow-mode-forward.gif", link, false, true));
            JRadioButtonMenuItem itemtn = new JRadioButtonMenuItem(new ChangeArrowsInArrowLinkAction(this, "backward", "images/arrow-mode-backward.gif", link, true, false));
            JRadioButtonMenuItem itemtt = new JRadioButtonMenuItem(new ChangeArrowsInArrowLinkAction(this, "both", "images/arrow-mode-both.gif", link, true, true));
            itemnn.setText(null);
            itemnt.setText(null);
            itemtn.setText(null);
            itemtt.setText(null);
            arrowLinkPopup.add(itemnn);
            arrowLinkPopup.add(itemnt);
            arrowLinkPopup.add(itemtn);
            arrowLinkPopup.add(itemtt);
            boolean a = !link.getStartArrow().equals("None");
            boolean b = !link.getEndArrow().equals("None");
            itemtt.setSelected(a && b);
            itemnt.setSelected(!a && b);
            itemtn.setSelected(a && !b);
            itemnn.setSelected(!a && !b);
            arrowLinkPopup.addSeparator();
            arrowLinkPopup.add(new GotoLinkNodeAction(this, link.getSource()));
            arrowLinkPopup.add(new GotoLinkNodeAction(this, link.getTarget()));
            arrowLinkPopup.addSeparator();
            HashSet<MindMapNode> NodeAlreadyVisited = new HashSet<MindMapNode>();
            NodeAlreadyVisited.add(link.getSource());
            NodeAlreadyVisited.add(link.getTarget());
            Vector links = this.getMindMapMapModel().getLinkRegistry().getAllLinks(link.getSource());
            links.addAll(this.getMindMapMapModel().getLinkRegistry().getAllLinks(link.getTarget()));
            for (int i = 0; i < links.size(); ++i) {
                MindMapArrowLinkModel foreign_link = (MindMapArrowLinkModel)links.get(i);
                if (NodeAlreadyVisited.add(foreign_link.getTarget())) {
                    arrowLinkPopup.add(new GotoLinkNodeAction(this, foreign_link.getTarget()));
                }
                if (!NodeAlreadyVisited.add(foreign_link.getSource())) continue;
                arrowLinkPopup.add(new GotoLinkNodeAction(this, foreign_link.getSource()));
            }
            return arrowLinkPopup;
        }
        return null;
    }

    private MindMapMapModel getMindMapMapModel() {
        return (MindMapMapModel)this.getController().getModel();
    }

    MindMapToolBar getToolBar() {
        return this.toolbar;
    }

    JToolBar getLeftToolBar() {
        return this.toolbar.getLeftToolBar();
    }

    protected void setAllActions(boolean enabled) {
        int i;
        super.setAllActions(enabled);
        this.increaseNodeFont.setEnabled(enabled);
        this.decreaseNodeFont.setEnabled(enabled);
        this.exportBranch.setEnabled(enabled);
        this.exportBranchToHTML.setEnabled(enabled);
        this.editLong.setEnabled(enabled);
        this.newSibling.setEnabled(enabled);
        this.newPreviousSibling.setEnabled(enabled);
        this.setLinkByFileChooser.setEnabled(enabled);
        this.setImageByFileChooser.setEnabled(enabled);
        this.followLink.setEnabled(enabled);
        for (i = 0; i < this.iconActions.size(); ++i) {
            ((Action)this.iconActions.get(i)).setEnabled(enabled);
        }
        this.save.setEnabled(enabled);
        this.saveAs.setEnabled(enabled);
        this.getToolBar().setAllActions(enabled);
        this.exportBranch.setEnabled(enabled);
        this.exportToHTML.setEnabled(enabled);
        this.importBranch.setEnabled(enabled);
        this.importLinkedBranch.setEnabled(enabled);
        this.importLinkedBranchWithoutRoot.setEnabled(enabled);
        for (i = 0; i < this.hookActions.size(); ++i) {
            ((Action)this.hookActions.get(i)).setEnabled(enabled);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MindMapFilter
    extends FileFilter {
        private MindMapFilter() {
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = Tools.getExtension(f.getName());
            if (extension != null) {
                return extension.equals("mm");
            }
            return false;
        }

        public String getDescription() {
            return MindMapController.this.getText("mindmaps_desc");
        }
    }

    private class FollowLinkAction
    extends AbstractAction {
        FollowLinkAction() {
            super(MindMapController.this.getText("follow_link"));
        }

        public void actionPerformed(ActionEvent e) {
            MindMapController.this.loadURL();
        }
    }

    private class ImportLinkedBranchWithoutRootAction
    extends AbstractAction {
        ImportLinkedBranchWithoutRootAction() {
            super(MindMapController.this.getText("import_linked_branch_without_root"));
        }

        public void actionPerformed(ActionEvent e) {
            MindMapNodeModel selected = (MindMapNodeModel)MindMapController.this.getSelected();
            if (selected == null || selected.getLink() == null) {
                JOptionPane.showMessageDialog(MindMapController.this.getView(), MindMapController.this.getText("import_linked_branch_no_link"));
                return;
            }
            URL absolute = null;
            try {
                String relative = selected.getLink();
                absolute = Tools.isAbsolutePath(relative) ? new File(relative).toURL() : new URL(MindMapController.this.getMap().getFile().toURL(), relative);
            }
            catch (MalformedURLException ex) {
                JOptionPane.showMessageDialog(MindMapController.this.getView(), "Couldn't create valid URL.");
                return;
            }
            try {
                MindMapNodeModel node = MindMapController.this.getMindMapMapModel().loadTree(new File(absolute.getFile()));
                ListIterator i = node.childrenUnfolded();
                while (i.hasNext()) {
                    MindMapNodeModel importNode = (MindMapNodeModel)i.next();
                    MindMapController.this.paste(importNode, (MindMapNode)selected);
                    MindMapController.this.invokeHooksRecursively(importNode, MindMapController.this.getMindMapMapModel());
                }
            }
            catch (Exception ex) {
                MindMapController.this.handleLoadingException(ex);
            }
        }
    }

    private class ImportLinkedBranchAction
    extends AbstractAction {
        ImportLinkedBranchAction() {
            super(MindMapController.this.getText("import_linked_branch"));
        }

        public void actionPerformed(ActionEvent e) {
            MindMapNodeModel selected = (MindMapNodeModel)MindMapController.this.getSelected();
            if (selected == null || selected.getLink() == null) {
                JOptionPane.showMessageDialog(MindMapController.this.getView(), MindMapController.this.getText("import_linked_branch_no_link"));
                return;
            }
            URL absolute = null;
            try {
                String relative = selected.getLink();
                absolute = Tools.isAbsolutePath(relative) ? new File(relative).toURL() : new URL(MindMapController.this.getMap().getFile().toURL(), relative);
            }
            catch (MalformedURLException ex) {
                JOptionPane.showMessageDialog(MindMapController.this.getView(), "Couldn't create valid URL for:" + MindMapController.this.getMap().getFile());
                ex.printStackTrace();
                return;
            }
            try {
                MindMapNodeModel node = MindMapController.this.getMindMapMapModel().loadTree(new File(absolute.getFile()));
                MindMapController.this.paste(node, (MindMapNode)selected);
                MindMapController.this.invokeHooksRecursively(node, MindMapController.this.getMindMapMapModel());
            }
            catch (Exception ex) {
                MindMapController.this.handleLoadingException(ex);
            }
        }
    }

    private class ImportBranchAction
    extends AbstractAction {
        ImportBranchAction() {
            super(MindMapController.this.getText("import_branch"));
        }

        public void actionPerformed(ActionEvent e) {
            int returnVal;
            MindMapNodeModel parent = (MindMapNodeModel)MindMapController.this.getSelected();
            if (parent == null) {
                return;
            }
            JFileChooser chooser = new JFileChooser();
            if (MindMapController.this.getFileFilter() != null) {
                chooser.addChoosableFileFilter(MindMapController.this.getFileFilter());
            }
            if ((returnVal = chooser.showOpenDialog(MindMapController.this.getFrame().getContentPane())) == 0) {
                try {
                    MindMapNodeModel node = MindMapController.this.getMindMapMapModel().loadTree(chooser.getSelectedFile());
                    MindMapController.this.paste(node, (MindMapNode)parent);
                    MindMapController.this.invokeHooksRecursively(node, MindMapController.this.getMindMapMapModel());
                }
                catch (Exception ex) {
                    MindMapController.this.handleLoadingException(ex);
                }
            }
        }
    }

    private class ExportBranchAction
    extends AbstractAction {
        ExportBranchAction() {
            super(MindMapController.this.getText("export_branch"));
        }

        public void actionPerformed(ActionEvent e) {
            int returnVal;
            MindMapNodeModel node = (MindMapNodeModel)MindMapController.this.getSelected();
            if (MindMapController.this.getMap() == null || node == null || node.isRoot()) {
                MindMapController.this.getFrame().err("Could not export branch.");
                return;
            }
            if (MindMapController.this.getMap().getFile() == null) {
                MindMapController.this.getFrame().out("You must save the current map first!");
                MindMapController.this.save();
            }
            JFileChooser chooser = MindMapController.this.getMap().getFile().getParentFile() != null ? new JFileChooser(MindMapController.this.getMap().getFile().getParentFile()) : new JFileChooser();
            if (MindMapController.this.getFileFilter() != null) {
                chooser.addChoosableFileFilter(MindMapController.this.getFileFilter());
            }
            if ((returnVal = chooser.showSaveDialog(MindMapController.this.getSelected().getViewer())) == 0) {
                File chosenFile = chooser.getSelectedFile();
                String ext = Tools.getExtension(chosenFile.getName());
                if (!ext.equals("mm")) {
                    chosenFile = new File(chosenFile.getParent(), chosenFile.getName() + ".mm");
                }
                try {
                    URL link = chosenFile.toURL();
                }
                catch (MalformedURLException ex) {
                    JOptionPane.showMessageDialog(MindMapController.this.getView(), "couldn't create valid URL!");
                    return;
                }
                MindMapNodeModel parent = (MindMapNodeModel)node.getParentNode();
                if (MindMapController.this.getMindMapMapModel().getFile() != null) {
                    try {
                        String linkToNewMapString = Tools.toRelativeURL(chosenFile.toURL(), MindMapController.this.getMindMapMapModel().getFile().toURL());
                        MindMapController.this.setLink(node, linkToNewMapString);
                    }
                    catch (MalformedURLException ex) {
                        // empty catch block
                    }
                }
                int nodePosition = parent.getChildPosition(node);
                MindMapController.this.deleteNode(node);
                node.setParent(null);
                MindMapMapModel map = new MindMapMapModel(node, MindMapController.this.getFrame());
                map.save(chosenFile);
                MindMapNode newNode = MindMapController.this.addNewNode(parent, nodePosition, node.isLeft());
                MindMapController.this.setNodeText(newNode, node.getText());
                try {
                    String linkString = Tools.toRelativeURL(MindMapController.this.getMindMapMapModel().getFile().toURL(), chosenFile.toURL());
                    MindMapController.this.setLink(newNode, linkString);
                }
                catch (MalformedURLException ex) {
                    // empty catch block
                }
            }
        }
    }

    protected class ExportBranchToHTMLAction
    extends AbstractAction {
        MindMapController c;

        public ExportBranchToHTMLAction(MindMapController controller) {
            super(MindMapController.this.getText("export_branch_to_html"));
            this.c = controller;
        }

        public void actionPerformed(ActionEvent e) {
            try {
                File file = File.createTempFile("tmm", ".html");
                if (this.c.getMindMapMapModel().saveHTML((MindMapNodeModel)MindMapController.this.getSelected(), file)) {
                    MindMapController.this.loadURL(file.toString());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected class ExportToHTMLAction
    extends AbstractAction {
        MindMapController c;

        public ExportToHTMLAction(MindMapController controller) {
            super(MindMapController.this.getText("export_to_html"));
            this.c = controller;
        }

        public void actionPerformed(ActionEvent e) {
            File file = new File(this.c.getMindMapMapModel().getFile() + ".html");
            if (this.c.getMindMapMapModel().saveHTML((MindMapNodeModel)this.c.getMindMapMapModel().getRoot(), file)) {
                MindMapController.this.loadURL(file.toString());
            }
        }
    }

    public class DefaultMindMapNodeCreator
    implements NewNodeCreator {
        public MindMapNode createNode(Object userObject) {
            return new MindMapNodeModel(userObject, MindMapController.this.getFrame());
        }
    }

    public static interface NewNodeCreator {
        public MindMapNode createNode(Object var1);
    }
}

