/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview;

import freemind.modes.MindMapNode;
import freemind.view.mindmapview.MapView;
import freemind.view.mindmapview.MoveableNodeView;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;

public class ForkNodeView
extends MoveableNodeView {
    public final int FOLDING_WIDTH_OVERHEAD = 3;

    public ForkNodeView(MindMapNode model, MapView map) {
        super(model, map);
    }

    public int getExtendedX() {
        int x = this.getX();
        if (this.getModel().isFolded() && this.isLeft()) {
            x -= this.getZoomedFoldingSymbolHalfWidth() * 2 + 3;
        }
        return x;
    }

    protected int getExtendedWidth(int width) {
        if (this.getModel().isFolded()) {
            width += this.getZoomedFoldingSymbolHalfWidth() * 2 + 3;
        }
        return width;
    }

    protected int getExtendedHeight(int height) {
        if (this.getModel().isFolded()) {
            height += this.getZoomedFoldingSymbolHalfWidth();
        }
        return height;
    }

    public void paintFoldingMark(Graphics2D g) {
        if (this.getModel().isFolded()) {
            Point out = this.getOutPoint();
            out.translate(0, 1);
            if (this.isLeft()) {
                g.drawLine(out.x - 3, out.y, out.x, out.y);
                g.drawOval(out.x - (this.getZoomedFoldingSymbolHalfWidth() * 2 + 3), out.y - this.getZoomedFoldingSymbolHalfWidth(), this.getZoomedFoldingSymbolHalfWidth() * 2, this.getZoomedFoldingSymbolHalfWidth() * 2);
            } else {
                g.drawLine(out.x, out.y, out.x + 3, out.y);
                g.drawOval(out.x + 3, out.y - this.getZoomedFoldingSymbolHalfWidth(), this.getZoomedFoldingSymbolHalfWidth() * 2, this.getZoomedFoldingSymbolHalfWidth() * 2);
            }
        }
    }

    public void paint(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        Dimension size = this.getSize();
        if (this.getModel() == null) {
            return;
        }
        this.paintSelected(g, size);
        this.paintDragOver(g, size);
        int edgeWidth = this.getEdge().getRealWidth();
        this.setRendering(g);
        g.setColor(this.getEdge().getColor());
        g.setStroke(this.getEdge().getStroke());
        g.drawLine(0, size.height - edgeWidth / 2 - 1, size.width, size.height - edgeWidth / 2 - 1);
        super.paint(g);
    }

    String getStyle() {
        return "fork";
    }
}

